package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;
import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.proto.EOrderRefundState;
import ru.yandex.travel.orders.proto.EOrderRefundType;
import ru.yandex.travel.orders.workflow.order.proto.EInvoiceRefundType;

@Entity
@Table(name = "order_refunds")
@Data
@EqualsAndHashCode(callSuper = false)
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name = "refund_type")
@BatchSize(size = 100)
public abstract class OrderRefund {
    @Id
    private UUID id;

    @ManyToOne(fetch = FetchType.LAZY)
    private Order order;

    @Type(type = "proto-enum")
    private EOrderRefundState state;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    private Instant lastTransitionAt;

    @Type(type = "proto-enum")
    private EInvoiceRefundType invoiceRefundType;

    public abstract EOrderRefundType getRefundType();

    public Instant getLastTransitionAt() {
        if (lastTransitionAt == null) {
            return createdAt;
        }
        return lastTransitionAt;
    }

    public boolean isCompleted() {
        return state == EOrderRefundState.RS_REFUNDED || state == EOrderRefundState.RS_FAILED;
    }

    public Money calculateRefundedAmount() {
        return null;
    }
}
