package ru.yandex.travel.orders.entities;

import java.util.List;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import lombok.Data;

@Data
public class OrderRefundPayload {
    private List<String> refundPartContexts;
    @Deprecated
    private boolean anyServiceRefundSuccess; // TODO(ganintsev): remove after release and add jsonIgnore by name
    private String refundToken;
    private List<OrderRefundServiceState> serviceRefundStates;

    @JsonIgnore
    public UUID nextPendingServiceRefund() {
        // TODO(ganintsev): check null just for backward compatibility, remove this after release.
        if (serviceRefundStates == null) {
            return null;
        }
        return serviceRefundStates.stream().filter(x -> x.getState() == ServiceRefundState.PENDING)
                .map(OrderRefundServiceState::getServiceId).findFirst().orElse(null);
    }

    public void changeServiceRefundState(UUID serviceId, ServiceRefundState expectedOldState, ServiceRefundState newState) {
        if (serviceRefundStates == null) {
            if (newState == ServiceRefundState.SUCCESS) {
                anyServiceRefundSuccess = true;
            }
            return;
        }
        OrderRefundServiceState stateItem = serviceRefundStates.stream()
                .filter(x -> x.getServiceId().equals(serviceId)).findFirst().orElseThrow();
        if (expectedOldState != null) {
            Preconditions.checkState(stateItem.getState() == expectedOldState,
                    "Expected service refund state %s, but actual: %s", expectedOldState, stateItem.getState());
        }
        stateItem.setState(newState);
    }

    @JsonIgnore
    public boolean allServiceRefundsDone() {
        if (serviceRefundStates == null) {
            return true;
        }
        return serviceRefundStates.stream()
                .allMatch(x -> x.getState() == ServiceRefundState.SUCCESS || x.getState() == ServiceRefundState.FAILED);
    }

    public boolean isAnyServiceRefundSuccess() {
        if (serviceRefundStates == null) {
            return anyServiceRefundSuccess;
        }
        return serviceRefundStates.stream().anyMatch(x -> x.getState() == ServiceRefundState.SUCCESS);
    }
}
