package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Getter;
import lombok.Setter;

/**
 * Событие "изменение/создание заказа".
 * Используется для отправки в Logbroker из OrdersUpdatesQueueStateRefresher
 * Таблица orders_updates_queue_state_changes используется в качестве очереди таких событий.
 * События генерируются в момент обработки hibernate-hook на обновление записей в БД в OrdersUpdateListenersIntegrator.
 */
@Entity
@Table(name = "orders_updates_queue_state_changes")
@Getter
@Setter
public class OrdersUpdatesQueueStateChange {
    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "orders_updates_queue_state_change_id_seq"
    )
    @SequenceGenerator(
            name = "orders_updates_queue_state_change_id_seq",
            sequenceName = "orders_updates_queue_state_change_id_seq",
            allocationSize = 1
    )
    private Long id;
    private UUID orderId;
    private Instant createdAt;

    public static OrdersUpdatesQueueStateChange createOrdersUpdatesQueueStateChange(UUID orderId) {
        OrdersUpdatesQueueStateChange change = new OrdersUpdatesQueueStateChange();
        change.setOrderId(orderId);
        change.setCreatedAt(Instant.now());
        return change;
    }
}
