package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.proto.EPaymentType;
import ru.yandex.travel.orders.workflow.payments.proto.EPaymentState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

public interface Payment extends WorkflowEntity<EPaymentState> {
    UUID getOwnerWorkflowId();

    EPaymentState getState();

    Money getTotalAmount();

    MoneyMarkup getTotalAmountMarkup();

    Money getPaidAmount();

    Set<UUID> getLogEntityIds();

    Invoice getLastAttempt();

    Invoice getLastPaidAttempt();

    List<Payment> getNextPayments();

    List<FiscalReceipt> getReceipts();

    Instant getPaymentEndsAt();

    Instant getClosedAt();

    EPaymentType getPaymentType();
}
