package ru.yandex.travel.orders.entities;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.UUID;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;
import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.services.payments.model.TrustBoundPaymentMethod;


@Entity
@Table(name = "payment_schedule_items")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class PaymentScheduleItem {
    @Id
    private UUID id;

    @ManyToOne
    private PaymentSchedule schedule;

    @OneToOne(cascade = CascadeType.ALL)
    private PendingInvoice pendingInvoice;

    private BigDecimal ratio;

    private String name;

    private Instant autoPaymentAt;

    private Instant emailReminderAt;

    private Instant ticketReminderAt;

    private Instant paymentEndsAt;

    @Type(type = "money-proto-enum")
    @Columns(columns = {
            @Column(name = "penalty_amount"), @Column(name = "penalty_currency")
    })
    private Money penaltyIfUnpaid;

    private boolean reminderEmailSent;

    private Boolean autoPaymentStarted;

    @Type(type = "jsonb-object")
    private TrustBoundPaymentMethod boundPaymentMethod;

    @OneToOne(fetch = FetchType.LAZY)
    private Ticket reminderTicket;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    @Version
    private Integer version;
}
