package ru.yandex.travel.orders.entities;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.workflow.trust.refund.proto.ETrustResizeState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@Getter
@Setter
@DiscriminatorValue("resize_trust_refund")
public class ResizeTrustRefund extends TrustRefund implements WorkflowEntity<ETrustResizeState> {

    @Type(type = "proto-enum")
    private ETrustResizeState state;

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.TRUST_RESIZE.getDiscriminatorValue();
    }

    @Override
    public ETrustResizeState getItemState() {
        return this.getState();
    }
}
