package ru.yandex.travel.orders.entities;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;

@Entity
@Table(name = "revinfo")
@org.hibernate.envers.RevisionEntity
public class RevisionEntity {
    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "revision_entity_id_seq"
    )
    @SequenceGenerator(
            name = "revision_entity_id_seq",
            sequenceName = "revision_entity_id_seq",
            allocationSize = 1
    )
    @RevisionNumber
    private Long id;

    @RevisionTimestamp
    private long timestamp;
}
