package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.time.LocalDateTime;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.workflow.trust.refund.proto.ETrustRefundState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@Entity
@Getter
@Setter
@DiscriminatorValue("simple_trust_refund")
@BatchSize(size = 100)
public class SimpleTrustRefund extends TrustRefund implements WorkflowEntity<ETrustRefundState> {

    @Type(type = "proto-enum")
    private ETrustRefundState state;

    private String trustRefundId;
    private Instant trustConfirmTs;

    private boolean systemRefreshScheduled;

    private LocalDateTime nextCheckStatusAt;

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.TRUST_REFUND.getDiscriminatorValue();
    }

    public static SimpleTrustRefund copy(SimpleTrustRefund simpleTrustRefund) {
        SimpleTrustRefund newRefund = new SimpleTrustRefund();
        newRefund.setState(ETrustRefundState.RS_NEW);
        newRefund.setDescription(simpleTrustRefund.getDescription());
        newRefund.setInvoice(simpleTrustRefund.getInvoice());
        newRefund.setOrderRefundId(simpleTrustRefund.getOrderRefundId());
        for (var item : simpleTrustRefund.getRefundItems()) {
            newRefund.addRefundItem(
                    item.getTrustOrderId(),
                    item.getOriginalAmount(),
                    item.getTargetAmount(),
                    item.getOriginalMarkup(),
                    item.getTargetMarkup()
            );
        }
        return newRefund;
    }

    public void rescheduleNextRefreshAt() {
        nextCheckStatusAt = LocalDateTime.now().plusSeconds(1);
    }

    @Override
    public ETrustRefundState getItemState() {
        return this.getState();
    }
}
