package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class StockInfo {
    @JsonProperty(value = "geo")
    private String region;
    @JsonProperty(value = "id")
    private String id;
    @JsonProperty(value = "dt")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private LocalDateTime dateTime;
    @JsonProperty(value = "ut")
    private Instant unixTime;
    @JsonProperty(value = "bv")
    private Double buyValue;
    @JsonProperty(value = "df")
    private String deltaFlag;
    @JsonProperty(value = "sv")
    private Double sellValue;

    @JsonProperty(value = "nscale")
    private Integer nominatorScale;
    @JsonProperty(value = "dscale")
    private Integer denominatorScale;
    @JsonProperty(value = "search_app_graph_base_url")
    private String searchAppGraphBaseUrl;
    @JsonProperty(value = "history")
    private List<Double> buyHistory;
    @JsonProperty(value = "shistory")
    private List<Double> sellHistory;
}
