package ru.yandex.travel.orders.entities;

import java.time.LocalDateTime;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;
import ru.yandex.travel.orders.commons.proto.EServiceType;
import ru.yandex.travel.orders.entities.partners.SuburbanBillingPartnerAgreement;
import ru.yandex.travel.orders.workflow.orderitem.generic.proto.EOrderItemState;
import ru.yandex.travel.suburban.model.SuburbanReservation;
import ru.yandex.travel.workflow.entities.WorkflowEntity;

@DiscriminatorValue(WellKnownOrderItemDiscriminator.ORDER_ITEM_SUBURBAN)
@Getter
@Setter
@Entity
public class SuburbanOrderItem extends OrderItem implements WorkflowEntity<EOrderItemState> {
    @Type(type = "proto-enum")
    private EOrderItemState state;

    @Type(type = "jsonb-object")
    @Column(name = "payload")
    private SuburbanReservation reservation;

    @Type(type = "jsonb-object")
    @Column(name = "agreement")
    private SuburbanBillingPartnerAgreement billingPartnerAgreement;

    @Override
    public SuburbanReservation getPayload() {
        return reservation;
    }

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.SUBURBAN_ORDER_ITEM.getDiscriminatorValue();
    }

    @Override
    public EServiceType getPublicType() {
        return EServiceType.PT_SUBURBAN;
    }

    @Override
    public LocalDateTime getServicedAt() {
        return LocalDateTime.now();
    }

    @Override
    public EOrderItemState getItemState() {
        return state;
    }

    @Override
    public Money preliminaryTotalCost() {
        return Money.zero(ProtoCurrencyUnit.RUB);
    }
}
