package ru.yandex.travel.orders.entities;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.orders.takeout.proto.ETakeoutJobState;
import ru.yandex.travel.orders.takeout.proto.ETakoutJobType;
import ru.yandex.travel.takeout.models.TakeoutResponse;

@Entity
@Table(name = "takeout_jobs")
@Data
public class TakeoutJob {
    @Id
    private UUID id;

    private String userPassportId;

    @Type(type = "proto-enum")
    private ETakoutJobType type;

    @Type(type = "proto-enum")
    private ETakeoutJobState state;

    @Type(type = "jsonb-object")
    private TakeoutResponse payload;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    public static TakeoutJob createJob(String userPassportId, ETakoutJobType type) {
        var job = new TakeoutJob();
        job.setUserPassportId(userPassportId);
        job.setId(UUID.randomUUID());
        job.setState(ETakeoutJobState.TS_NEW);
        job.setType(type);
        return job;
    }
}
