package ru.yandex.travel.orders.entities;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.travel.train.model.CustomerInfo;

@Entity
@Table(name = "train_customer_info")
@Data
@EqualsAndHashCode(callSuper = false)
public class TrainCustomerInfo {
    @Id
    private Integer customerId;
    @NotNull
    private Integer orderId;
    @NotNull
    private Integer buyOperationId;
    @NotNull
    private String firstName;
    @NotNull
    private String lastName;
    @NotNull
    private String middleName;

    public TrainCustomerInfo() {}

    public TrainCustomerInfo(CustomerInfo source) {
        this.customerId = source.getCustomerId();
        this.orderId = source.getOrderId();
        this.buyOperationId = source.getBuyOperationId();
        this.firstName = source.getFirstName();
        this.lastName = source.getLastName();
        this.middleName = source.getMiddleName();
    }
}
