package ru.yandex.travel.orders.entities;

import java.time.Instant;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name = "train_discounts")
@Data
public class TrainDiscount {
    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "train_discounts_id_seq"
    )
    @SequenceGenerator(
            name = "train_discounts_id_seq",
            sequenceName = "train_discounts_id_seq",
            allocationSize = 1
    )
    private Long id;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    private Instant departureTime;

    private String trainNumber;

    private String documentNumber;

    private String tariffCode;

    @ManyToOne(fetch = FetchType.LAZY)
    private TrainOrderItem orderItem;
}
