package ru.yandex.travel.orders.entities;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.commons.proto.EOrderType;
import ru.yandex.travel.orders.workflow.train.proto.ETrainOrderState;
import ru.yandex.travel.workflow.entities.WorkflowEntity;


/**
 * New train orders are created as {@link GenericOrder}.
 */
@Entity
@Getter
@Setter
@DiscriminatorValue(value = "train_order")
public class TrainOrder extends Order implements WorkflowEntity<ETrainOrderState> {
    @Type(type = "proto-enum")
    private ETrainOrderState state;

    @Override
    public EOrderType getPublicType() {
        return EOrderType.OT_TRAIN;
    }

    @Override
    public String getEntityType() {
        return WellKnownWorkflowEntityType.TRAIN_ORDER.getDiscriminatorValue();
    }

    @Override
    public ETrainOrderState getEntityState() {
        return state;
    }

    private Boolean moneyAcquired;

    public boolean isMoneyAcquired() {
        return moneyAcquired != null && moneyAcquired;
    }
}
