package ru.yandex.travel.orders.entities;

import java.util.List;
import java.util.UUID;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;

import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.orders.proto.EOrderRefundState;
import ru.yandex.travel.orders.proto.EOrderRefundType;

@DiscriminatorValue("train_order_insurance_auto_refund")
@Getter
@Setter
@Entity
public class TrainOrderInsuranceAutoRefund extends OrderRefund {
    public static TrainOrderInsuranceAutoRefund createForOrder(Order order) {
        var refund = new TrainOrderInsuranceAutoRefund();
        refund.setId(UUID.randomUUID());
        refund.setState(EOrderRefundState.RS_NEW);
        order.addOrderRefund(refund);
        return refund;
    }

    @OneToMany(mappedBy = "orderRefund")
    private List<TrainInsuranceRefund> insuranceRefunds;

    @Override
    public EOrderRefundType getRefundType() {
        return EOrderRefundType.RT_TRAIN_INSURANCE_AUTO_RETURN;
    }
}
