package ru.yandex.travel.orders.entities;

import java.util.List;
import java.util.UUID;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;

import lombok.Getter;
import lombok.Setter;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;
import ru.yandex.travel.orders.proto.EOrderRefundState;
import ru.yandex.travel.orders.proto.EOrderRefundType;
import ru.yandex.travel.orders.workflow.orderitem.train.ticketrefund.proto.ETrainTicketRefundState;

@DiscriminatorValue("train_order_office_refund")
@Getter
@Setter
@Entity
public class TrainOrderOfficeRefund extends OrderRefund implements TrainOrderRefund {
    @OneToMany(mappedBy = "orderRefund")
    private List<TrainTicketRefund> trainTicketRefunds;

    public static TrainOrderOfficeRefund createForOrder(Order order) {
        var refund = new TrainOrderOfficeRefund();
        refund.setId(UUID.randomUUID());
        refund.setState(EOrderRefundState.RS_NEW);
        refund.setOrder(order);
        return refund;
    }

    @Override
    public EOrderRefundType getRefundType() {
        return EOrderRefundType.RT_TRAIN_OFFICE_REFUND;
    }

    public TrainTicketRefund getTicketRefund() {
        return trainTicketRefunds == null || trainTicketRefunds.size() == 0 ? null : trainTicketRefunds.get(0);
    }

    @Override
    public Money calculateRefundedAmount() {
        ProtoCurrencyUnit currency = getOrder().getCurrency();
        TrainTicketRefund ticketRefund = getTicketRefund();
        if (ticketRefund != null && ticketRefund.getState() == ETrainTicketRefundState.RS_REFUNDED) {
            return ticketRefund.getPayload().calculateActualRefundSum();
        }
        return Money.zero(currency);
    }
}
