package ru.yandex.travel.orders.entities;

import java.util.List;
import java.util.UUID;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;

import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.orders.proto.EOrderRefundState;
import ru.yandex.travel.orders.proto.EOrderRefundType;

@DiscriminatorValue("train_order_user_refund")
@Getter
@Setter
@Entity
public class TrainOrderUserRefund extends OrderRefund implements TrainOrderRefund {
    @OneToMany(mappedBy = "orderRefund")
    private List<TrainTicketRefund> trainTicketRefunds;

    public static TrainOrderUserRefund createForOrder(Order order) {
        var refund = new TrainOrderUserRefund();
        refund.setId(UUID.randomUUID());
        refund.setState(EOrderRefundState.RS_NEW);
        order.addOrderRefund(refund);
        return refund;
    }

    @Override
    public EOrderRefundType getRefundType() {
        return EOrderRefundType.RT_TRAIN_USER_REFUND;
    }

    public TrainTicketRefund getTicketRefund() {
        return (trainTicketRefunds == null || trainTicketRefunds.size() == 0) ? null : trainTicketRefunds.get(0);
    }
}
