package ru.yandex.travel.orders.entities;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.commons.proto.EVat;

@AllArgsConstructor
@Getter
public enum VatType {
    VAT_NONE("vat_none", EVat.VAT_NONE, "nds_none", 0, null),
    VAT_18("vat_18", EVat.VAT_18, "nds_18", 18, null),
    VAT_20("vat_20", EVat.VAT_20, "nds_20", 20, null),
    VAT_10("vat_10", EVat.VAT_10, "nds_10", 10, null),
    VAT_0("vat_0", EVat.VAT_0, "nds_0", 0, null),
    VAT_18_118("vat_18_118", EVat.VAT_18_118, "nds_18_118", 18, 118),
    VAT_20_120("vat_20_120", EVat.VAT_20_120, "nds_20_120", 20, 120),
    VAT_10_110("vat_10_110", EVat.VAT_10_110, "nds_10_110", 10, 110);

    private final static EnumIndex<EVat, VatType> index = EnumIndex.create(VatType.class, t -> t.protoValue);

    private final String value;
    private final EVat protoValue;
    private final String trustValue;
    private final Integer percent;
    private final Integer basePercent;

    public static VatType fromEVat(EVat eVat) {
        return index.getByValue(eVat);
    }

    public Integer getBasePercentWithFallback() {
        return basePercent != null ? basePercent : 100 + percent;
    }
}
