package ru.yandex.travel.orders.entities;

import java.util.UUID;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;

public enum WellKnownAccount {
    YANDEX("YANDEX", "0-0-0-0-385", ProtoCurrencyUnit.RUB),
    YANDEX_USD("YANDEX_USD", "0-0-0-0-703", ProtoCurrencyUnit.USD),
    TRUST("TRUST", "0-0-0-0-891", ProtoCurrencyUnit.RUB),
    EXPEDIA("EXPEDIA", "0-0-0-0-188", ProtoCurrencyUnit.USD);

    private final String name;
    private final UUID uuid;
    private final ProtoCurrencyUnit currency;

    WellKnownAccount(String value, String uuid, ProtoCurrencyUnit currency) {
        this.name = value;
        this.uuid = UUID.fromString(uuid);
        this.currency = currency;
    }

    public String toString() {
        return String.format("{name: %s, uuid: %s}", this.name, this.uuid.toString());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ProtoCurrencyUnit getCurrency() {
        return currency;
    }
}
