package ru.yandex.travel.orders.entities;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;

import ru.yandex.travel.orders.proto.EInvoiceType;

public class WellKnownInvoiceDiscriminator {
    public static final String INVOICE_TRUST = "trust_invoice";
    public static final String INVOICE_AEROFLOT = "aeroflot_invoice";

    public static final BiMap<String, EInvoiceType> INVOICE_DISCRIMINATOR_TYPE_MAPPING =
            ImmutableBiMap.<String, EInvoiceType>builder()
                    .put(INVOICE_TRUST, EInvoiceType.IT_TRUST)
                    .put(INVOICE_AEROFLOT, EInvoiceType.IT_AVIA_AEROFLOT)
                    .build();
}
