package ru.yandex.travel.orders.entities;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import ru.yandex.travel.orders.commons.proto.EServiceType;


@NoArgsConstructor(access = AccessLevel.PRIVATE)
public final class WellKnownOrderItemDiscriminator {
    public static final String ORDER_ITEM_AEROFLOT = "aeroflot";
    public static final String ORDER_ITEM_BUS = "bus";
    public static final String ORDER_ITEM_DOLPHIN = "dolphin";
    public static final String ORDER_ITEM_EXPEDIA = "expedia";
    public static final String ORDER_ITEM_TRAIN = "train";
    public static final String ORDER_ITEM_TRAVELLINE = "travelline";
    public static final String ORDER_ITEM_BNOVO = "bnovo";
    public static final String ORDER_ITEM_SUBURBAN = "suburban";
    public static final String ORDER_ITEM_BRONEVIK = "bronevik";

    public static final BiMap<String, EServiceType> ORDER_ITEM_DISCRIMINATOR_TYPE_MAPPING =
            ImmutableBiMap.<String, EServiceType>builder()
                    .put(ORDER_ITEM_AEROFLOT, EServiceType.PT_FLIGHT)
                    .put(ORDER_ITEM_BUS, EServiceType.PT_BUS)
                    .put(ORDER_ITEM_DOLPHIN, EServiceType.PT_DOLPHIN_HOTEL)
                    .put(ORDER_ITEM_EXPEDIA, EServiceType.PT_EXPEDIA_HOTEL)
                    .put(ORDER_ITEM_TRAIN, EServiceType.PT_TRAIN)
                    .put(ORDER_ITEM_TRAVELLINE, EServiceType.PT_TRAVELLINE_HOTEL)
                    .put(ORDER_ITEM_BNOVO, EServiceType.PT_BNOVO_HOTEL)
                    .put(ORDER_ITEM_SUBURBAN, EServiceType.PT_SUBURBAN)
                    .put(ORDER_ITEM_BRONEVIK, EServiceType.PT_BRONEVIK_HOTEL)
                    .build();
}
