package ru.yandex.travel.orders.entities;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum WellKnownWorkflowEntityType {
    // hotels
    HOTEL_ORDER("hotel_order"),
    EXPEDIA_ORDER_ITEM("expedia_order_item"),
    DOLPHIN_ORDER_ITEM("dolphin_order_item"),
    TRAVELLINE_ORDER_ITEM("travelline_order_item"),
    BNOVO_ORDER_ITEM("bnovo_order_item"),
    BRONEVIK_ORDER_ITEM("bronevik_order_item"),
    VOUCHER("voucher"),
    EMAIL("email"),
    // avia
    AEROFLOT_ORDER("aeroflot_order"),
    AEROFLOT_ORDER_ITEM("aeroflot_order_item"),
    AEROFLOT_INVOICE("aeroflot_invoice"),
    AEROFLOT_MQ_MESSAGE("aeroflot_mq_message"),
    // payments
    TRUST_INVOICE("trust_invoice"),
    TRUST_REFUND("trust_refund"),
    TRUST_RESIZE("trust_resize"),
    PENDING_INVOICE("pending_invoice"),
    PLUS_POINTS_TOPUP("plus_points_topup"),
    // tracking
    STARTREK_ISSUE("startrek_issue"),
    ORDER_SUPERVISOR("order_supervisor"),
    GENERIC_ERROR_SUPERVISOR("generic_error_supervisor"),
    // train
    TRAIN_ORDER("train_order"),
    TRAIN_ORDER_ITEM("train_order_item"),
    TRAIN_TICKET_REFUND("train_ticket_refund"),
    TRAIN_INSURANCE_REFUND("train_insurance_refund"),
    // suburban
    SUBURBAN_ORDER_ITEM("suburban_order_item"),
    // bus
    BUS_ORDER_ITEM("bus_order_item"),
    BUS_TICKET_REFUND("bus_ticket_refund"),
    // notifications
    NOTIFICATION("notification"),
    ATTACHMENT("attachment"),
    // GENERIC
    GENERIC_ORDER("generic_order"),
    // scheduled payments
    PAYMENT_SCHEDULE("payment_schedule");
    @Getter
    private final String discriminatorValue;

    public boolean equalsValue(String value) {
        return this.discriminatorValue.equals(value);
    }
    }
