package ru.yandex.travel.orders.entities.context;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;

@AllArgsConstructor(access = AccessLevel.PRIVATE)
@Builder
@EqualsAndHashCode(callSuper = false)
@ToString
@JsonDeserialize(builder = SimpleMultiItemBatch.SimpleMultiItemBatchBuilder.class)
public class SimpleMultiItemBatch extends ProcessingBatch<UUID, SimpleMultiItemBatchTaskState> {
    @Getter(AccessLevel.PROTECTED)
    private final String name;
    @Getter(AccessLevel.PROTECTED)
    private final Map<UUID, SimpleMultiItemBatchTaskState> states;

    public SimpleMultiItemBatch(String name) {
        this(name, new HashMap<>());
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class SimpleMultiItemBatchBuilder {
    }
}
