package ru.yandex.travel.orders.entities.finances;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name = "bank_orders")
@Data
@NoArgsConstructor
public class BankOrder {

    /**
     * Идентификатор, генерируется на нашей стороне
     */
    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "bank_order_id_seq"
    )
    @SequenceGenerator(
            name = "bank_order_id_seq",
            sequenceName = "bank_order_id_seq",
            allocationSize = 1
    )
    private long id;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    @Version
    private Integer version;

    /**
     * Идентификатор сервиса.
     */
    private long serviceId;

    /**
     * Номер платежного поручения.
     */
    private String bankOrderId;

    /**
     * Время обновления статуса.
     */
    private LocalDateTime trantime;

    /**
     * Дата платежа.
     */
    private LocalDate eventtime;

    /**
     * Описание платежа
     */
    private String description;

    /**
     * Статус платежа.
     */
    @Type(type = "custom-enum")
    private BankOrderStatus status;

    /**
     * Итоговая сумма выплаты по ПП, в валюте договора.
     */
    private BigDecimal sum;

    /**
     * Статус платежного поручения в ОЕБС.
     */
    @Type(type = "custom-enum")
    private OebsPaymentStatus oebsPaymentStatus;

    /**
     * Группировка расшифровки платежного поручения
     */
    @ManyToOne(
            fetch = FetchType.LAZY,
            cascade = CascadeType.ALL
    )
    @JoinColumn(name = "payment_batch_id")
    private BankOrderPayment bankOrderPayment;

    /**
     * Отправлен ли отчет партнеру по п/п. Если статус RETURNED, вместо письма создаем задачу в startrek.
     */
    private Boolean reportSent;


    public boolean getReportSent() {
        if (reportSent == null) {
            return false;
        }
        return reportSent;
    }
}
