package ru.yandex.travel.orders.entities.finances;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;

@Entity
@Table(name = "bank_order_details")
@Data
@NoArgsConstructor
public class BankOrderDetail {

    /**
     * Идентификатор, генерируется на нашей стороне
     */
    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "bank_order_details_id_seq"
    )
    @SequenceGenerator(
            name = "bank_order_details_id_seq",
            sequenceName = "bank_order_details_id_seq",
            allocationSize = 1
    )
    private long id;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    @Version
    private Integer version;

    @ManyToOne(
            fetch = FetchType.LAZY,
            cascade = CascadeType.ALL
    )
    @JoinColumn(name = "payment_batch_id")
    private BankOrderPayment bankOrderPayment;

    /**
     * Идентификатор платежа.
     */
    private String trustPaymentId;

    /**
     * Идентификатор возврата.
     */
    private String trustRefundId;

    /**
     * Идентификатор платежа из Yt. Получается из trustPaymentId/trustRefundId и используется для связи с BillingTransaction
     */
    private Long ytId;

    /**
     * Абсолютная величина суммы заказа (строчки в корзине), в валюте ПП.
     */
    private BigDecimal sum;

    /**
     * Валюта ПП.
     */
    @Type(type = "proto-currency-unit")
    private ProtoCurrencyUnit currency;

    /**
     * Метод оплаты.
     * <p/>
     * В текущей реализации не соответствует всем значениям BillingTransactionPaymentType, а отрабает только деление
     * между COST/REWARD назначением денег.
     */
    @Type(type = "custom-enum")
    private BillingTransactionPaymentType paymentType;

    /**
     * Тип транзакции.
     */
    @Type(type = "custom-enum")
    private BillingTransactionType transactionType;

    /**
     * Дата передачи в OEBS.
     */
    private LocalDate handlingTime;

    /**
     * Дата совершения операции.
     */
    private LocalDate paymentTime;

    /**
     * Идентификатор договора с партнером.
     */
    private Long contractId;

    /**
     * Идентификатор заказа на сервисе.
     */
    private String serviceOrderId;

    /**
     * Величина агентского вознаграждения.
     */
    private BigDecimal agencyCommission;
}
