package ru.yandex.travel.orders.entities.finances;

import java.util.EnumSet;
import java.util.Set;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum BankOrderPaymentDetailsStatus {


    NEW("new"),
    FETCHED("fetched"),
    SKIPPED("skipped"),
    NOT_FULLY_FETCHED("not_fully_fetched");

    public static Set<BankOrderPaymentDetailsStatus> STATUSES_FOR_UPDATE = EnumSet.of(NEW, NOT_FULLY_FETCHED);

    private final String value;
}
