package ru.yandex.travel.orders.entities.finances;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum BankOrderStatus {

    NEW("new"),
    /**
     * Платеж отменен.
     */
    CANCELLED("cancelled"),
    /**
     * Платеж был отправлен в банк, но обработка не начата.
     */
    STARTED("started"),
    /**
     * Платеж принят к обработке.
     */
    DONE("done");

    private final String value;
}
