package ru.yandex.travel.orders.entities.finances;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@RequiredArgsConstructor
@Getter
public enum BillingTransactionPaymentSystemType implements ValueBasedEnum<String> {
    SBERBANK("sberbank"),
    INSURANCE("insurance"),
    YANDEX_MONEY("yamoney"),
    PROMO_CODE("promocode"),
    YANDEX("yandex"),
    POSTPAY("postpay");

    private final String value;

    private static final EnumIndex<String, BillingTransactionPaymentSystemType> index =
            EnumIndex.create(BillingTransactionPaymentSystemType.class);

    public static BillingTransactionPaymentSystemType forValue(String value) {
        return index.getByValue(value);
    }
}
