package ru.yandex.travel.orders.entities.finances;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@RequiredArgsConstructor
@Getter
public enum BillingTransactionPaymentType implements ValueBasedEnum<String> {
    COST("cost"),
    REWARD("reward"),
    COST_INSURANCE("cost_insurance"),
    REWARD_INSURANCE("reward_insurance"),
    FEE("fee"),
    // these 3 types are defined in https://st.yandex-team.ru/BILLINGPLAN-823
    YANDEX_ACCOUNT_TOPUP("yandex_account_topup"),
    YANDEX_ACCOUNT_COST_WITHDRAW("yandex_account_withdraw"),
    YANDEX_ACCOUNT_REWARD_WITHDRAW("reward_account_withdraw");

    private final String value;

    private static final EnumIndex<String, BillingTransactionPaymentType> index =
            EnumIndex.create(BillingTransactionPaymentType.class);

    public static BillingTransactionPaymentType forValue(String value) {
        return index.getByValue(value);
    }
}
