package ru.yandex.travel.orders.entities.finances;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@RequiredArgsConstructor
@Getter
public enum BillingTransactionType implements ValueBasedEnum<String> {
    PAYMENT("payment"),
    REFUND("refund");

    private final String value;

    private static final EnumIndex<String, BillingTransactionType> index =
            EnumIndex.create(BillingTransactionType.class);

    public static BillingTransactionType forValue(String value) {
        return index.getByValue(value);
    }
}
