package ru.yandex.travel.orders.entities.finances;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@RequiredArgsConstructor
@Getter
public enum FinancialEventPaymentScheme implements ValueBasedEnum<String> {
    HOTELS("hotels", 641),
    HOTELS_POSTPAY("hotels_postpay", 1210),
    SUBURBAN("suburban", 716),
    TRAINS("trains", 171),
    AEROEXPRESS("aeroexpress", 607);

    private final String value;
    private final long serviceId;

    private static final EnumIndex<String, FinancialEventPaymentScheme> index =
            EnumIndex.create(FinancialEventPaymentScheme.class);

    public static FinancialEventPaymentScheme forValue(String value) {
        return index.getByValue(value);
    }
}
