package ru.yandex.travel.orders.entities.finances;

import java.util.Map;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.orders.admin.proto.EFinancialEventType;

@RequiredArgsConstructor
@Getter
public enum FinancialEventType {
    PAYMENT("payment"),
    INSURANCE_PAYMENT("insurance_payment"),
    REFUND("refund"),
    INSURANCE_REFUND("insurance_refund"),
    MANUAL_PAYMENT("manual_payment"),
    MANUAL_REFUND("manual_refund"),
    YANDEX_ACCOUNT_TOPUP_PAYMENT("yandex_account_topup_payment"),
    YANDEX_ACCOUNT_TOPUP_REFUND("yandex_account_topup_refund");

    private final String value;

    private static final Map<EFinancialEventType, FinancialEventType> fromProtoEventTypeMap = Map.of(
        EFinancialEventType.EET_PAYMENT, PAYMENT,
        EFinancialEventType.EET_INSURANCE_PAYMENT, INSURANCE_PAYMENT,
        EFinancialEventType.EET_REFUND, REFUND,
        EFinancialEventType.EET_INSURANCE_REFUND, INSURANCE_REFUND,
        EFinancialEventType.EET_MANUAL_PAYMENT, MANUAL_PAYMENT,
        EFinancialEventType.EET_MANUAL_REFUND, MANUAL_REFUND,
        EFinancialEventType.EET_YANDEX_ACCOUNT_TOPUP_PAYMENT, YANDEX_ACCOUNT_TOPUP_PAYMENT,
        EFinancialEventType.EET_YANDEX_ACCOUNT_TOPUP_REFUND, YANDEX_ACCOUNT_TOPUP_REFUND
    );

    public static FinancialEventType convertFromProto(EFinancialEventType eventType) {
        if (fromProtoEventTypeMap.containsKey(eventType)) {
            return fromProtoEventTypeMap.get(eventType);
        } else {
            throw new RuntimeException(String.format("FinancialEventType %s is not found in the mapping", eventType));
        }
    }
}
