package ru.yandex.travel.orders.entities.finances;

import lombok.Getter;
import lombok.RequiredArgsConstructor;


@RequiredArgsConstructor
@Getter
public enum OebsPaymentStatus {
    /**
     * Присваивается новому, созданному пакету платежей в OEBS.
     */
    CREATED("created"),
    /**
     * Присваивается, когда пакет платежей передан на обработку в балалайку.
     */
    TRANSMITTED("transmitted"),
    /**
     * Присваивается, когда пакет платежей успешно прошел валидацию в балалайке
     * (в ОЕБС запустился запрос, который получает статус платежей из Балалайки, и отработал корректно).
     */
    CONFIRMED("confirmed"),
    /**
     * Присваивается, когда платеж выверился со строкой банковской выписки.
     */
    RECONCILED("reconciled"),
    /**
     * Присваивается, если платеж не прошел валидацию в балалайке / (в банке - для реестра Тинькофф) или был отклонен
     * вручную (т.е. платеж или аннулирован или отвергнут в Балалайке).
     */
    VOID("void"),
    /**
     * Присваивается, когда платеж выверился со строкой возврата, переданной в банковской выписке.
     */
    RETURNED("returned");

    private final String value;
}
