package ru.yandex.travel.orders.entities.migrations;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.entities.context.OrderStateContext;
import ru.yandex.travel.orders.workflow.order.generic.proto.EOrderState;
import ru.yandex.travel.orders.workflow.train.proto.ETrainOrderState;

@Entity
@Table(name = "train_order_migrations")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TrainOrderMigration {
    @Id
    private UUID id;

    private UUID orderId;

    @Type(type = "proto-enum")
    private ETrainOrderState oldState;

    @Type(type = "proto-enum")
    private EOrderState newState;

    @Type(type = "jsonb-object")
    private OrderStateContext newStateContext;

    private Instant migratedAt;
}
