package ru.yandex.travel.orders.entities.mock;

import java.time.Instant;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.orders.commons.proto.EAviaCheckAvailabilityOutcome;
import ru.yandex.travel.orders.commons.proto.EAviaConfirmationOutcome;
import ru.yandex.travel.orders.commons.proto.EAviaMqEventOutcome;

@Entity
@Table(name = "mock_aeroflot_orders")
@Data
public class MockAeroflotOrder {

    @Id
    private UUID id;

    private String pnr;

    @Type(type = "proto-enum")
    private EAviaCheckAvailabilityOutcome checkAvailabilityResult;

    @Type(type = "proto-enum")
    private EAviaConfirmationOutcome confirmationResult;

    @Type(type = "proto-enum")
    private EAviaMqEventOutcome mqEventResult;

    private Instant sendMqEventAt;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    @Version
    private Integer version;
}
