package ru.yandex.travel.orders.entities.mock;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Type;
import org.javamoney.moneta.Money;

import ru.yandex.travel.buses.backend.proto.worker.TOrder;
import ru.yandex.travel.orders.commons.proto.TBusTestContext;

@Entity
@Table(name = "mock_bus_orders")
@Data
public class MockBusOrder {
    @Data
    static public class MockBusOrderData {
        private boolean confirmed;
        private boolean cancelled;
        private String rideId;

        private List<MockBusRefundData> refunds;
    }

    @Data
    static public class MockBusRefundData {
        private String orderId;
        private String ticketId;
        private Money price;
    }

    public MockBusOrder() {
        payload = new MockBusOrderData();
        payload.refunds = new ArrayList<>();
    }

    @Id
    private String id;

    @Type(type = "jsonb-object")
    @Column(name = "payload")
    private MockBusOrderData payload;

    @Type(type = "protobuf-value")
    @Columns(columns = {
            @Column(name = "context_class_name"), @Column(name = "context_data")
    })
    private TBusTestContext testContext;

    @Type(type = "protobuf-value")
    @Columns(columns = {
            @Column(name = "order_class_name"), @Column(name = "order_data")
    })
    private TOrder protoOrder;
}
