package ru.yandex.travel.orders.entities.mock;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import lombok.Data;
import org.hibernate.annotations.Type;

import ru.yandex.travel.train.partners.im.model.ReservationCreateResponse;

@Entity
@Table(name = "mock_train_orders")
@Data
public class MockTrainOrder {

    @Data
    static public class MockTrainOrderData {
        private ReservationCreateResponse reservationCreateResponse = null;
        private boolean confirmed;
        private boolean cancelled;
        private UUID orderId;
        private Instant alwaysTimeoutAt;
    }

    public MockTrainOrder() {
        data = new MockTrainOrderData();
    }

    @Id
    private int id;

    @Type(type = "jsonb-object")
    @Column(name = "data")
    private MockTrainOrderData data;

    @OneToMany(mappedBy = "order")
    private List<MockTrainOrderItem> items;
}
