package ru.yandex.travel.orders.entities.mock;

import java.time.Instant;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Type;

import ru.yandex.travel.orders.commons.proto.TTrainTestContext;
import ru.yandex.travel.train.partners.im.model.orderinfo.OrderItemResponse;

@Entity
@Table(name = "mock_train_order_items")
@Data
public class MockTrainOrderItem {
    @RequiredArgsConstructor
    @Getter
    public enum MockTrainOrderItemType {
        PURCHASE("purchase"), INSURANCE("insurance"), REFUND("refund"), INSURANCE_REFUND("insurance_refund");

        private final String value;
    }

    @Data
    @NoArgsConstructor
    public static class MockTrainOrderItemData {
        private OrderItemResponse itemInfo;
        private Instant officeRefundAt;
        private Instant officeAcquireAt;

        public MockTrainOrderItemData(OrderItemResponse itemInfo) {
            this.itemInfo = itemInfo;
        }
    }

    @Id
    private int id;

    @Type(type = "custom-enum")
    private MockTrainOrderItemType type;

    @ManyToOne(optional = false)
    @JoinColumn(name = "order_id", nullable = false)
    private MockTrainOrder order;

    @Type(type = "jsonb-object")
    @Column(name = "data")
    private MockTrainOrderItemData itemData;

    @Type(type = "protobuf-value")
    @Columns(columns = {
            @Column(name = "context_class_name"), @Column(name = "context_data")
    })
    private TTrainTestContext testContext;
}
