package ru.yandex.travel.orders.entities.mock;

import java.math.BigDecimal;
import java.util.UUID;

import javax.persistence.Entity;
import javax.persistence.Id;

import lombok.Data;

import ru.yandex.travel.orders.services.payments.model.plus.TrustTopupRequest;

@Entity(name = "mock_trust_accounts")
@Data
public class MockTrustAccount {
    @Id
    private UUID id;
    private String uid;
    private String currency;
    private BigDecimal balance;

    public void add(BigDecimal amount) {
        if (balance != null) {
            balance = balance.add(amount);
        } else {
            balance = amount;
        }
    }

    public static MockTrustAccount newOne(TrustTopupRequest request, String uid) {
        MockTrustAccount account = new MockTrustAccount();
        account.setCurrency(request.getCurrency());
        account.setBalance(BigDecimal.valueOf(request.getAmount()));
        account.setUid(uid);
        account.setId(UUID.randomUUID());
        return account;
    }
}
