package ru.yandex.travel.orders.entities.mock;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.orders.commons.proto.EAviaTokenizationOutcome;
import ru.yandex.travel.orders.commons.proto.TPaymentTestContext;
import ru.yandex.travel.orders.services.payments.model.PaymentStatusEnum;

@Entity
@Table(name = "mock_trust_baskets")
@Data
public class MockTrustBasket {

    @Id
    private UUID id;

    @Type(type = "custom-enum")
    private MockTrustBasketType type;

    @Type(type = "proto-enum")
    private EAviaTokenizationOutcome tokenizationOutcome;

    @Type(type = "protobuf-value")
    @Columns(columns = {
            @Column(name = "test_context_class_name"), @Column(name = "test_context_data")
    })
    private TPaymentTestContext testContext;

    @Type(type = "custom-enum")
    private PaymentStatusEnum state;

    @Type(type = "jsonb-object")
    @Column(name = "payload")
    private MockTrustBasketInternalState payload;

    @OneToMany(mappedBy = "trustBasket", cascade = CascadeType.ALL)
    @Getter(AccessLevel.NONE)
    @Setter(AccessLevel.NONE)
    private List<MockTrustRefund> refunds;

    private Instant authorizedAt;

    private Instant userActionMustOccurAt;

    private Boolean sendCallback;

    private Instant callbackSentAt;

    private Instant clearedAt;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    @Version
    private Integer version;

    public void addTrustRefund(MockTrustRefund refund) {
        if (refunds == null) {
            refunds = new ArrayList<>();
        }
        refund.setTrustBasket(this);
        refunds.add(refund);
    }

    public List<MockTrustRefund> getRefunds() {
        return refunds == null ? Collections.emptyList() : Collections.unmodifiableList(refunds);
    }
}
