package ru.yandex.travel.orders.entities.mock;

import java.math.BigDecimal;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

@Data
public class MockTrustBasketInternalState {
    private String purchaseToken;
    private Map<String, MockTrustInternalOrderRecord> orders;
    private String trustPaymentId;

    @JsonIgnore
    public BigDecimal getTotal() {
        return orders.values().stream().map(MockTrustInternalOrderRecord::getPrice)
                .reduce(BigDecimal.ZERO, (v, acc) -> acc.add(v));
    }
}
