package ru.yandex.travel.orders.entities.mock;

import java.text.MessageFormat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum MockTrustBasketType {
    STANDARD("standard"),
    CARD_TOKENIZATION("card_tokenization");

    private final String value;

    MockTrustBasketType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static MockTrustBasketType fromValue(String value) {
        for (MockTrustBasketType candidate : MockTrustBasketType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Couldn''t find enum of type {0} for string {1}", MockTrustBasketType.class, value));
    }
}
