package ru.yandex.travel.orders.entities.mock;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import lombok.Data;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.UpdateTimestamp;

import ru.yandex.travel.orders.services.payments.model.TrustRefundState;

@Entity
@Table(name = "mock_trust_refunds")
@Data
public class MockTrustRefund {
    @Id
    private UUID id;

    @ManyToOne
    private MockTrustBasket trustBasket;

    @Type(type = "custom-enum")
    private TrustRefundState state;

    @Type(type = "jsonb-object")
    @Column(name = "payload")
    private MockTrustRefundInternalState payload;

    @CreationTimestamp
    private Instant createdAt;

    @UpdateTimestamp
    private Instant updatedAt;

    @Version
    private Integer version;

    public static MockTrustRefund refundFor(String reason, Map<String, BigDecimal> orderDeltas) {
        MockTrustRefund result = new MockTrustRefund();
        result.setId(UUID.randomUUID());
        MockTrustRefundInternalState payload = new MockTrustRefundInternalState();
        payload.setReason(reason);
        payload.setOrderDeltas(new HashMap<>(orderDeltas));
        result.setPayload(payload);
        result.setState(TrustRefundState.WAIT_FOR_NOTIFICATION);
        return result;
    }
}
