package ru.yandex.travel.orders.entities.mock.suburban;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Type;

import ru.yandex.travel.suburban.partners.movista.MovistaOrderStatus;


@Entity
@Table(name = "mock_suburban_order_items")
@Data
public class MockSuburbanOrderItem {
    @Data
    @NoArgsConstructor
    public static class MovistaOrderState {
        LocalDate travelDate;
        Integer fromExpressId;
        Integer toExpressId;
        Integer fareId;
        BigDecimal price;

        Integer orderId;
        MovistaOrderStatus status;
        Instant validDate;
        Instant confirmDate;

        String ticketBody;
        Integer ticketNumber;

        HandlerState bookHandler = new HandlerState();
        HandlerState confirmHandler = new HandlerState();
        HandlerState orderInfoHandler = new HandlerState();
        HandlerState blankPdfHandler = new HandlerState();
    }

    @Data
    @NoArgsConstructor
    public static class ImOrderState {
        LocalDate travelDate;
        Integer fromExpressId;
        Integer toExpressId;

        Integer orderId;
        Integer blankOrderItemId;
        Integer blankId;
        Instant validDate;
        BigDecimal price;

        String ticketBody;
        String ticketNumber;

        HandlerState createHandler = new HandlerState();
        HandlerState confirmHandler = new HandlerState();
        HandlerState orderInfoHandler = new HandlerState();
        HandlerState ticketBarcodeHandler = new HandlerState();
        HandlerState blankHandler = new HandlerState();
    }

    @Data
    public static class AeroexpressOrderState {
    }

    @Data
    public static class HandlerState {
        Integer errorsCount = 0;
    }

    @Id
    @GeneratedValue(
            strategy = GenerationType.SEQUENCE,
            generator = "mock_suburban_order_items_id_seq")
    @SequenceGenerator(
            name = "mock_suburban_order_items_id_seq",
            sequenceName = "mock_suburban_order_items_id_seq",
            allocationSize = 1)

    private int id;

    @Column(name = "order_item_id")
    private UUID orderItemId;

    @Type(type = "jsonb-object")
    @Column(name = "movista_order")
    private MovistaOrderState movistaOrder;

    @Type(type = "jsonb-object")
    @Column(name = "im_order")
    private ImOrderState imOrder;
}
