package ru.yandex.travel.orders.entities.notifications;

import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum AttachmentProviderType {
    IM("im"),
    URL("url"),
    FISCAL_RECEIPT("fiscal_receipt"),

    SUBURBAN_COUPON("suburban_coupon"),

    // Outdated attachment type - replaced by SUBURBAN_COUPON.
    // But still used in AttachmentsHelper for storage purposes
    MOVISTA_COUPON("movista_coupon"),

    // the following providers are virtual, they generate reports on the fly, no need to implement a separate downloader
    HOTEL_BOOKING_REPORT("hotel_booking_report"),
    HOTEL_PAYOUT_REPORT("hotel_payout_report"),
    HOTEL_ACCOUNTING_ACT("hotel_accounting_act"),
    ;

    private final String value;

    public String getValue() {
        return value;
    }
}
