package ru.yandex.travel.orders.entities.notifications;

import com.fasterxml.jackson.annotation.JsonTypeName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import ru.yandex.travel.train.partners.im.model.OrderReservationBlankRequest;

@Data
@EqualsAndHashCode(callSuper = false)
@JsonTypeName("ImAttachmentProviderData")
public class ImAttachmentProviderData extends BaseAttachmentProviderData {
    private OrderReservationBlankRequest blankRequest;
    private Boolean fakeAttachment;

    public ImAttachmentProviderData() {
    }

    public ImAttachmentProviderData(OrderReservationBlankRequest blankRequest) {
        this.blankRequest = blankRequest;
    }

    public ImAttachmentProviderData(OrderReservationBlankRequest blankRequest, Boolean fakeAttachment) {
        this.blankRequest = blankRequest;
        this.fakeAttachment = fakeAttachment;
    }
}
