package ru.yandex.travel.orders.entities.notifications.hotels;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConfirmedOrderMailRequest extends MailSenderArgs {
    private String checkinTimes;
    private String checkoutTimes;
    private Boolean mirCashback;
    private DeferMode deferMode;
    private Integer deferredAmount;
    private Integer paidAmount;
    private String deferredDate;
    private Integer deferredPenalty;
    private String paymentUrl;

    public enum DeferMode {
        FULL,
        INITIAL,
        DEFERRED
    }
}
