package ru.yandex.travel.orders.entities.notifications.hotels;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import lombok.Data;

import ru.yandex.travel.hotels.common.orders.Guest;

@Data
public class MailSenderArgs {
    private Integer totalOrderVolume;
    private String orderId;
    private String contactsName;
    private String roomName;

    /**
     * list of known guest names separated by comma.
     *
     * Preferably should be removed eventually, and replaced with usage of {@link #guestsList}.
     */
    private String guests;
    private List<Guest> guestsList;

    private String checkinDate;
    private String checkoutDate;
    private String hotelName;
    private String supportPhone;
    private String orderUrl;

    public void setGuestsList(List<Guest> guestsList) {
        this.guestsList = guestsList;
        setGuests(guestsList.stream()
                .map(Guest::getFullName)
                .filter(Objects::nonNull)
                .collect(Collectors.joining(", ")));
    }
}
