package ru.yandex.travel.orders.entities.notifications.trains;

import java.util.List;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

@Data
public class TrainBaseMailSenderArgs {
    private String ticketNumber;
    private UUID orderUid;
    private String frontUrl;

    private String stationFromTitle;
    private String stationToTitle;
    private String trainNumber;
    private String trainTitle;
    private String coachNumber;
    private String coachType;
    private String departureDateLocal;
    private String departureTimeLocal;
    private String departureDateRw;
    private String departureTimeRw;
    private String departureTzNameRw;
    private String arrivalDateLocal;
    private String arrivalTimeLocal;
    private String arrivalDateRw;
    private String arrivalTimeRw;
    private String arrivalTzNameRw;

    private String mainFirstName;
    private String mainFullName;
    @JsonProperty("is_moscow_region")
    private Boolean isMoscowRegion;
    @JsonProperty("is_international_route")
    private Boolean isInternationalRoute;

    private List<TrainPassengerArgs> passengers;
}
