package ru.yandex.travel.orders.entities.partners;

import java.time.Instant;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Entity
@Table(name = "billing_partner_configs")
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class BillingPartnerConfig {
    @Id
    public Long billingClientId;

    public boolean agreementActive;

    public boolean generateTransactions;

    public boolean exportToYt;

    public boolean synchronizeAgreement;

    public Instant createdAt;

    public Instant synchronizedAt;
}
